// ------------------------------------------------------------------
// ANDROID
// ------------------------------------------------------------------

xitai.addPreference("android sdk", "string", "Folder", {})

var android = xitai.platformKlass("android", {
	arch: "android",
	vfs: false,
	content: function() { return this.DEST+"/src/main/assets" },
	create: function(app) {
		xitai.warning("Creating android project on '"+this.DEST+"'\n")
		var S = host.native_slash
		this.ORIENTATION = app.get("width") > app.get("height") ? "landscape" : "portrait"

		this.ANDROID_SDK = xitai.preferences().get("android sdk")
		this.ADB = this.ANDROID_SDK + S + "platform-tools" + S + "adb"
		this.KEYSTORE = this.get("key_store")
		this.STOREPASS = this.get("store_pass")
		this.ALIAS = this.get("alias")
		this.KEYPASS = this.get("key_pass")

		this.TITLE = app.get("title")
		this.DNAME = this.get("Variant name")
		var ai = xitai.applicationInfo();
		this.DOMAIN = ai.get("company_domain")
		this.VERS_CODE = ai.get("version_code")
		this.VERS_NAME = ai.get("version_name")
		this.PACKAGE = ai.get("normalized_pack")
		this.PACKAGE_DIR = ai.get("normalized_path")
	//	this.CLASS_NAME = ai.get("normalized_name")
		this.CLASS_NAME = this.get("class_name")


		skel = this.SOURCE+"/skel"
		main = this.DEST+"/src/main"

		host.mkdir(main+"/java/"+this.PACKAGE_DIR)
		file_translate(this, skel+"/AndroidManifest.xml", main+"/AndroidManifest.xml")
		file_translate(this, skel+"/Main.java", main+"/java/"+this.PACKAGE_DIR+"/"+this.CLASS_NAME+".java")

		host.mkdir(main+"/res/values")
		file_translate(this, skel+"/strings.xml", main+"/res/values/strings.xml")
		file_gcopy(skel+"/res/*", main+"/res")

		host.mkdir(this.DEST+"/libs")
		file_gcopy (skel+"/libs/*aar", this.DEST+"/libs")
		file_translate (this, skel+"/build.gradle", this.DEST+"/build.gradle")
		file_translate (this, skel+"/local.properties", this.DEST+"/local.properties")
		if(this.KEYSTORE !== "")
			{
			file_translate (this, skel+"/keygen.cmd", this.DEST+"/keygen.cmd")
			host.setExecutable (this.DEST+"/keygen.cmd");
			}
		file_gcopy(skel+"/gradle", this.DEST)
		file_gcopy(skel+"/gradlew", this.DEST)
		file_gcopy(skel+"/gradlew.bat", this.DEST)
		host.setExecutable (this.DEST+"/gradlew")

		file_translate (this, skel+"/mk.cmd", this.DEST+"/mk.cmd")
		file_translate (this, skel+"/mk", this.DEST+"/mk")
		file_translate (this, skel+"/mkb.cmd", this.DEST+"/mkb.cmd")
		file_translate (this, skel+"/mkb", this.DEST+"/mkb")
		file_translate (this, skel+"/install.cmd", this.DEST+"/install.cmd")
		file_translate (this, skel+"/logcat.cmd", this.DEST+"/logcat.cmd")
		host.setExecutable (this.DEST+"/mk.cmd")
		host.setExecutable (this.DEST+"/mk")
		host.setExecutable (this.DEST+"/mkb.cmd")
		host.setExecutable (this.DEST+"/mkb")
		host.setExecutable (this.DEST+"/install.cmd")
		host.setExecutable (this.DEST+"/logcat.cmd")

		var icon = app.get("app_icon")
		if(icon !== "")
			{
			icon = host.fullpath(icon)
			host.scaleImage(icon, main+"/res/drawable-hdpi/ic_launcher.png", 72, 72)
			host.scaleImage(icon, main+"/res/drawable-ldpi/ic_launcher.png", 36, 36)
			host.scaleImage(icon, main+"/res/drawable-mdpi/ic_launcher.png", 48, 48)
			host.scaleImage(icon, main+"/res/drawable-xhdpi/ic_launcher.png", 96, 96)
			}
		var splash = app.get("splash_image")
		if(splash !== "")
			{
			file_copy(host.fullpath(splash), main+"/res/drawable/splash.png")
			}
		xitai.warning("-- OK --\n")
		}
	});

android.addAttribute("class_name", "string", "String", {})
android.addAttribute("key_store", "string", "String", {})
android.addAttribute("store_pass", "string", "String", {})
android.addAttribute("alias", "string", "String", {})
android.addAttribute("key_pass", "string", "String", {})

