// -----------------------------------------------------------------------
// WINDOWS
// -----------------------------------------------------------------------

xitai.addPreference("NSIS directory", "string", "Folder", {})

function make_platform()
	{
	var desktop_CREATE = 1
	var desktop_LAUNCH = 2
	var desktop_SHELL = 4
	var desktop_BINARIES = 8
	var desktop_INSTALLER = 16

	var engine_file = DIR + "/engine.json"
	var machine = host.machine

	function desktop_create(plat, app, flags)
		{
		xitai.warning("Creating win executable on '"+ plat.DEST + "'\n")
		var ai = xitai.applicationInfo();
		var icon = app.get("app_icon")
		if(icon !== "")
			{
			file_copy(host.fullpath(icon), plat.DEST+"/icon.png")
			xitai.makeIcoFromPng(plat.DEST+"/icon.ico", host.fullpath(icon));
			}
		host.mkdir(plat.DEST+"/data")
		file_copy(host.fullpath("data/logo.png"), plat.DEST+"/data/logo.png")
		xitai.makeAppInfo(plat.DEST);
		if(flags & desktop_BINARIES)
			{
			file_copy(engine_file, plat.DEST+"/engine.json")
			if(flags & desktop_SHELL)
				file_copy(plat.SOURCE+"/xitai_shell.exe", plat.DEST+"/xitai_shell.exe")
			file_copy(plat.SOURCE+"/xitai_player.exe", plat.DEST+"/xitai_player.exe")
			var dlls = [
				'libgcc_s_seh-1.dll', 'libstdc++-6.dll', 'libwinpthread-1.dll', 'libpng16-16.dll zlib1.dll',
				/* 'libogg-0.dll', 'libvorbis-0.dll', 'libvorbisfile-3.dll', 'libvorbisenc-2.dll',
				'libFLAC-8.dll', 'libmodplug-1.dll', 'libfluidsynth-2.dll', 'libportaudio-2.dll',
				'libspeex-1.dll', 'libsndfile-1.dll', 'libglib-2.0-0.dll', 'libgmodule-2.0-0.dll',
				'libiconv-2.dll', 'libidn-12.dll', 'libintl-8.dll', 'libpcre-1.dll',
				'libreadline7.dll', 'libtermcap-0.dll' */
				]
			for(var f in dlls)
				file_gcopy(plat.EDITOR+"/"+dlls[f], plat.DEST)
			xitai.makeEngineInfo(plat.DEST);

			this.SOURCE = plat.DEST
			this.NAME = ai.get("normalized_name") + "-" + ai.get("version_name")
			nsis_script = plat.DEST+"-installer.nsi"
			file_translate(this, plat.SOURCE+"/inscript.nsi", nsis_script)
			makensis = xitai.preferences().get("NSIS directory") + "/makensis.exe"
			if(flags & desktop_INSTALLER)
				{
				xitai.warning("Make installer\n")
				host.execw(makensis, [nsis_script])
				}
			}
		xitai.warning("-- OK --\n")
		}

	function desktop_launch(plat, app)
		{
		var p = host.getenv("PATH")
		host.setenv("PATH", plat.EDITOR+";"+p)
		host.exec(plat.SOURCE+"/xitai_player.exe", plat.DEST+"/defaults.xip")
		}

	var desktop = xitai.platformKlass("win64",
		{
		arch: machine,
		media: true,
		content: function() { return this.DEST },
		init: function() { this.set("options", desktop_CREATE + desktop_BINARIES) },
		create: function(app)
			{
			var flags = this.get("options")
			if(flags & desktop_CREATE) desktop_create(this, app, flags)
			if(flags & desktop_LAUNCH) desktop_launch(this, app)
			}
		});

	desktop.addAttribute("options", "int", "Flags", {
			create:desktop_CREATE,
			launch:desktop_LAUNCH,
			shell:desktop_SHELL,
			binaries:desktop_BINARIES,
			installer:desktop_INSTALLER
			})
	}

make_platform()
