// -----------------------------------------------------------------------
// LINUX
// -----------------------------------------------------------------------

function make_platform()
	{
	var desktop_CREATE = 1
	var desktop_LAUNCH = 2
	var desktop_SHELL = 4
	var desktop_BINARIES = 8

	var engine_file = DIR + "/engine.json"
	var info = JSON.parse(host.loadString(engine_file))
	var xinfo = JSON.parse(host.loadString(xitai.bundlePath + "/engine.json"))

	var distro = info.platform.distro
	var native = xinfo.platform.distro
	var machine = info.platform.machine
	//xitai.warning("Platform: " + distro + ", " + native + "-" + machine + "\n")

	var desktop = xitai.platformKlass(distro, {
		main: true,

		arch: machine,

		content: function()
			{
			return this.DEST;
			},

		init: function()
			{
			this.set("options", desktop_CREATE + desktop_BINARIES)
			},

		create: function(app)
			{
			var flags = this.get("options")
			var plat = this
			if(flags & desktop_CREATE)
				{
				xitai.warning("Creating linux executable on '" + plat.DEST + "'\n")
				var ai = xitai.applicationInfo()
				var exename = ai.get("normalized_name")
				var icon = app.get("app_icon")
				if(icon !== "")
					file_copy(host.fullpath(icon), plat.DEST+"/icon.png")
				file_copy(host.fullpath("data/logo.png"), plat.DEST+"/data/logo.png")
				xitai.makeAppInfo(plat.DEST);
				if(flags & desktop_BINARIES)
					{
					file_copy(engine_file, plat.DEST+"/engine.json")
					if(flags & desktop_SHELL)
						{
						file_copy(plat.SOURCE+"/xitai_shell", plat.DEST+"/xitai_shell")
						host.setExecutable(plat.DEST+"/xitai_shell")
						}
					file_copy(plat.SOURCE+"/xitai_player", plat.DEST+"/xitai_player")
					host.setExecutable(plat.DEST+"/xitai_player")
					xitai.makeEngineInfo(plat.DEST);
					}
				xitai.warning("-- OK --\n")
				}
			if(flags & desktop_LAUNCH)
				{
				xitai.warning("Launching "+plat.SOURCE+"/xitai_player ...\n")
				host.exec(plat.SOURCE+"/xitai_player", plat.DEST+"/defaults.xip")
				}
			}
		})
	if(native === distro)
		desktop.addAttribute("options", "int", "Flags", { create:desktop_CREATE, launch:desktop_LAUNCH, shell:desktop_SHELL, binaries:desktop_BINARIES })
	else	desktop.addAttribute("options", "int", "Flags", { create:desktop_CREATE, shell:desktop_SHELL, binaries:desktop_BINARIES })
	}

make_platform()
