// -----------------------------------------------------------------------
// OSX
// -----------------------------------------------------------------------

function make_platform()
	{
	var desktop_CREATE = 1
	var desktop_LAUNCH = 2
	var desktop_SHELL = 4
	var desktop_BINARIES = 8

	var engine_file = DIR + "/engine.json"
	var machine = host.machine

	function desktop_create(plat, app)
		{
		file_copy(engine_file, plat.DEST+".app/engine.json")
		file_copy(host.fullpath("data/logo.png"), plat.DEST+".app/data/logo.png")
		xitai.makeAppInfo(plat.DEST+'.app');

		var ai = xitai.applicationInfo();

		xitai.warning("Creating osx executable on '"+plat.DEST+"'\n")
		file_gcopy(plat.SOURCE+"/player.app/*", plat.CONTENT)
		host.setExecutable(plat.CONTENT+"/Contents/MacOS/xitai_player")

		var libs = [ 'libpng16.16.dylib', 'libcrypto.1.1.dylib', 'libssl.1.1.dylib',
			'libvorbis.0.dylib', 'libvorbisfile.3.dylib', 'libogg.0.dylib', 'libtheoradec.1.dylib',
			'SDL2.framework', 'SDL2_mixer.framework' ]
		var src = plat.EDITOR+"/Contents/Frameworks"
		var dst = plat.CONTENT+"/Contents/Frameworks"
		for(var l in libs)
			file_gcopy(src+"/"+libs[l], dst)

		plat.VERSION = ai.get("version_name") + "(" + ai.get("package_date")  + ")"
		plat.TITLE = app.get("title")
		file_translate(plat, plat.SOURCE+"/player.app/Contents/Info.plist", plat.CONTENT+"/Contents/Info.plist")

		var icon = app.get("app_icon")
		if(icon !== "")
			{
			icon = host.fullpath(icon)
			xitai.warning("Generando icono from "+icon+"\n")
			host.rmdir(plat.TMP+"/icons.iconset")
			host.mkdir(plat.TMP+"/icons.iconset")
			host.exec("sips", ["-z",  "16",  "16", icon, "--out", plat.TMP+"/icons.iconset/icon_16x16.png"])
			host.exec("sips", ["-z",  "32",  "32", icon, "--out", plat.TMP+"/icons.iconset/icon_32x32.png"])
			host.exec("sips", ["-z",  "64",  "64", icon, "--out", plat.TMP+"/icons.iconset/icon_64x64.png"])
			host.exec("sips", ["-z", "128", "128", icon, "--out", plat.TMP+"/icons.iconset/icon_128x128.png"])
			host.exec("sips", ["-z", "256", "256", icon, "--out", plat.TMP+"/icons.iconset/icon_256x256.png"])
			host.exec("sips", ["-z", "512", "512", icon, "--out", plat.TMP+"/icons.iconset/icon_512x512.png"])
			host.exec("iconutil", ["-c", "icns", '-o', plat.CONTENT+"/Contents/Resources/icons.icns", plat.TMP+"/icons.iconset"])
			}
		xitai.makeEngineInfo(plat.DEST+'.app');
		xitai.warning("-- OK --\n")
		}

	function desktop_launch(plat, app)
		{
		xitai.warning("Launching "+plat.SOURCE+"/player.app ...\n")
		host.exec(plat.SOURCE+"/player.app/Contents/MacOS/xitai_player", plat.CONTENT+"/defaults.xip")
		}

	var desktop = xitai.platformKlass("osx", {
		main: true,
		arch: machine,
		content: function() { return this.DEST +'.app'; },
		init: function() { this.set("options", desktop_CREATE + desktop_LAUNCH) },
		create: function(app)
			{
			var flags = this.get("options")
			if(flags & desktop_CREATE) desktop_create(this, app)
			if(flags & desktop_LAUNCH) desktop_launch(this, app)
			}
		})
	desktop.addAttribute("options", "int", "Flags", { create:desktop_CREATE, launch:desktop_LAUNCH })
	}

make_platform()
